/*
 * Decompiled with CFR 0.152.
 */
package org.python.core;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import java.util.zip.ZipEntry;
import org.python.core.Py;
import org.python.core.PyList;
import org.python.core.PyObject;
import org.python.core.PySystemState;
import org.python.core.PyUnicode;
import org.python.core.SyspathArchive;
import org.python.core.util.RelativeFile;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SyspathJavaLoader
extends ClassLoader {
    private static final char SLASH_CHAR = '/';

    public SyspathJavaLoader(ClassLoader classLoader) {
        super(classLoader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getBytesFromInputStream(InputStream inputStream, int n) {
        try {
            byte[] byArray = new byte[n];
            for (int i = 0; i < n; i += inputStream.read(byArray, i, n - i)) {
            }
            byte[] byArray2 = byArray;
            return byArray2;
        }
        catch (IOException iOException) {
            byte[] byArray = null;
            return byArray;
        }
        finally {
            try {
                inputStream.close();
            }
            catch (IOException iOException) {}
        }
    }

    private byte[] getBytesFromDir(String string, String string2) {
        try {
            File file = this.getFile(string, string2);
            if (file == null) {
                return null;
            }
            return this.getBytesFromInputStream(new FileInputStream(file), (int)file.length());
        }
        catch (FileNotFoundException fileNotFoundException) {
            return null;
        }
        catch (SecurityException securityException) {
            return null;
        }
    }

    private byte[] getBytesFromArchive(SyspathArchive syspathArchive, String string) {
        String string2 = string.replace('.', '/') + ".class";
        ZipEntry zipEntry = syspathArchive.getEntry(string2);
        if (zipEntry == null) {
            return null;
        }
        try {
            return this.getBytesFromInputStream(syspathArchive.getInputStream(zipEntry), (int)zipEntry.getSize());
        }
        catch (IOException iOException) {
            return null;
        }
    }

    protected Package definePackageForClass(String string) {
        int n = string.lastIndexOf(46);
        if (n < 0) {
            return null;
        }
        String string2 = string.substring(0, n);
        Package package_ = this.getPackage(string2);
        if (package_ == null) {
            package_ = this.definePackage(string2, null, null, null, null, null, null, null);
        }
        return package_;
    }

    @Override
    protected Class<?> findClass(String string) throws ClassNotFoundException {
        PySystemState pySystemState = Py.getSystemState();
        ClassLoader classLoader = pySystemState.getClassLoader();
        if (classLoader != null) {
            return classLoader.loadClass(string);
        }
        PyList pyList = pySystemState.path;
        for (int i = 0; i < pyList.__len__(); ++i) {
            byte[] byArray;
            Object object;
            PyObject pyObject = SyspathJavaLoader.replacePathItem(pySystemState, i, pyList);
            if (pyObject instanceof SyspathArchive) {
                object = (SyspathArchive)pyObject;
                byArray = this.getBytesFromArchive((SyspathArchive)object, string);
            } else {
                if (!(pyObject instanceof PyUnicode)) {
                    pyObject = pyObject.__str__();
                }
                object = pyObject.toString();
                byArray = this.getBytesFromDir((String)object, string);
            }
            if (byArray == null) continue;
            this.definePackageForClass(string);
            return this.defineClass(string, byArray, 0, byArray.length);
        }
        throw new ClassNotFoundException(string);
    }

    @Override
    protected URL findResource(String string) {
        PySystemState pySystemState = Py.getSystemState();
        if (string.charAt(0) == '/') {
            string = string.substring(1);
        }
        String string2 = string;
        if (File.separatorChar != '/') {
            string = string.replace('/', File.separatorChar);
            string2 = string2.replace(File.separatorChar, '/');
        }
        PyList pyList = pySystemState.path;
        for (int i = 0; i < pyList.__len__(); ++i) {
            Object object;
            Object object2;
            PyObject pyObject = SyspathJavaLoader.replacePathItem(pySystemState, i, pyList);
            if (pyObject instanceof SyspathArchive) {
                object2 = (SyspathArchive)pyObject;
                object = ((SyspathArchive)object2).getEntry(string2);
                if (object == null) continue;
                try {
                    return new URL("jar:file:" + pyObject.__str__().toString() + "!/" + string2);
                }
                catch (MalformedURLException malformedURLException) {
                    throw new RuntimeException(malformedURLException);
                }
            }
            if (!(pyObject instanceof PyUnicode)) {
                pyObject = pyObject.__str__();
            }
            object2 = pySystemState.getPath(pyObject.toString());
            try {
                object = new File((String)object2, string);
                if (!((File)object).exists()) continue;
                return ((File)object).toURI().toURL();
            }
            catch (MalformedURLException malformedURLException) {
                throw new RuntimeException(malformedURLException);
            }
        }
        return null;
    }

    static PyObject replacePathItem(PySystemState pySystemState, int n, PyList pyList) {
        PyObject pyObject = pyList.__getitem__(n);
        if (pyObject instanceof SyspathArchive) {
            return pyObject;
        }
        try {
            pyObject = new SyspathArchive(pySystemState.getPath(pyObject.toString()));
        }
        catch (Exception exception) {
            return pyObject;
        }
        pyList.__setitem__(n, pyObject);
        return pyObject;
    }

    private File getFile(String string, String string2) {
        String string3 = "";
        boolean bl = true;
        StringTokenizer stringTokenizer = new StringTokenizer(string2, ".");
        while (stringTokenizer.hasMoreTokens()) {
            String string4 = stringTokenizer.nextToken();
            if (!bl) {
                string3 = string3 + File.separator;
            }
            string3 = string3 + string4;
            bl = false;
        }
        return new RelativeFile(string, string3 + ".class");
    }
}

